SELECT asdt.transaction_id,
       asdt.session_id,
       asdt.transaction_sequence_num,
       asdt.first_snapshot_sequence_num,
       asdt.commit_sequence_num,
       asdt.is_snapshot,
       asdt.elapsed_time_seconds,
       st.text AS commande_SQL
FROM   sys.dm_tran_active_snapshot_database_transactions AS asdt
       INNER JOIN sys.dm_exec_connections AS ec
             ON asdt.session_id = ec.most_recent_session_id
       INNER JOIN sys.dm_tran_database_transactions AS dt
             ON asdt.transaction_id = dt.transaction_id
       CROSS APPLY sys.dm_exec_sql_text(ec.most_recent_sql_handle) AS st
WHERE  dt.database_id = DB_ID();